$(document).ready(function () {
    $('div#flash').on('click', function () {
        $(this).hide();
    });

    $(".add_button").removeClass('addButtonForm').addClass('addButtonForm');


    $("#sidebarleft,#sidebarright").on('click', function (e) {
        e.stopPropagation();
    });


    $("div#bandeau.responsive .menu").click(function (e) {
        $(document).click(function () {
            $("div.dropdownmenu.responsive").slideUp(500);
            $(document).unbind('click');
        });

        $("div.dropdownmenu.responsive").css({'width': '100%'});
        if ($("div.dropdownmenu.responsive").is(":visible")) {
            $("div.dropdownmenu.responsive").slideUp(500);
            $(document).unbind('click');
        } else {
            $("div.dropdownmenu.responsive").slideDown(500);
        }
        e.stopPropagation();
    });

    $('.opencapture').bind('click', function (e) {
        e.preventDefault();
        capture($('form#capture input#email_capture').val());
    });

    $('button#btn_help').bind('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var id = $('.search-help').prop('id');
        $.fancybox({
            href: "#" + id,
            openEffect: 'fade',
            closeEffect: 'fade',
            helpers: {
                title: {
                    type: 'inside'
                },
                overlay: {
                    css: {
                        'background': 'rgba(255, 255, 255, 0.8)'
                    }
                }
            }
        });
    });

    // bouton revenir en haut
    if ($(window).width() > 960) {
        $("body").append('<div id="btn_up" title="Back to top"></div>');
        $('#btn_up').on('click', function () {
            $('html,body').animate({scrollTop: 0}, 'slow');
        });

        $(window).scroll(function () {
            if ($(window).scrollTop() < 250) {
                $('#btn_up').stop().animate({
                    opacity: 0
                });
            } else {
                $('#btn_up').stop().animate({
                    opacity: 1
                });
            }
        });
    }

    // Search thoughts
    $('.results.thoughts .result').bind('click', function () {
        if ($(this).hasClass('collapse')) {
            $('.content', $(this)).hide();
            $('.description', $(this)).show();
            $(this).removeClass('collapse');
        } else {
            $('.description', $(this)).hide();
            $('.content', $(this)).show();
            $(this).addClass('collapse');
        }
    });

    $('.thought.date').show();


    var $elt = $("input#date");
    $elt.datepicker({
        format: 'yyyy-mm-dd',
        date: datePage,
        startDate: $("input#date").data('start'),
        endDate: $("input#date").data('end'),
        language: culture.substr(0, 2)
    });

    $(".bydate").bind('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $elt.datepicker('show');
    });

    $elt.bind('pick.datepicker', function (e) {
        if (e.view == 'day') {
            var d = e.date.getFullYear() + '-' + ('0' + (e.date.getMonth() + 1)).slice(-2) + '-' + ('0' + e.date.getDate()).slice(-2);

            window.location = folder + d;
        }
    });

    /* Aide sur la recherche */
    $('.search-help').hide();

    /* Recherche en responsive */
    $('#search-div').bind('click', function () {
        if ($('div.search.responsive').is(':visible')) {
            $("div.search.responsive").slideUp()
        } else {
            window.scroll(top);
            $("div.search.responsive").slideDown();
        }
    });

    /* slider */
    function slider() {
        var w = $(window).width();
        if (w < 800) {
            $('section#slider').hide();
            $('section#slider-responsive').show();
        } else {
            $('section#slider').show();
            $('section#slider-responsive').hide();
        }
    }

    $(window).bind('resize', slider);
    slider();

    /* Teaser pensée */
    $('div.teaser').bind('click', function () {
        $(this).hide();
        $('.thought-container').css({height: 'auto'});
    });

    $('input#cg[type=checkbox]').bind('change', function () {
        var checked = !$(this).is(':checked');
        $('input#btn-next').prop('disabled', checked);
    });
});

