<?php
// retour array('label'=>'', 'amount'=>0)
/** Order */
function discount($order)
{
    $ret = ['label' => '', 'amount' => 0];
    $variables = $order->getRequest()->getVariables();
    $codes = $variables->getValueByName('codepromo');

    $key = strtoupper($order->codepromo);
    if (is_array($codes) && array_key_exists($key, $codes)) {
        $start = convertDte($codes[$key][0]['start'] . ' 00:00:00');
        $end = convertDte($codes[$key][0]['end'] . ' 23:59:59');
        $now = new \DateTime();
        if ((!$start || $now >= $start) && (!$end || $now < $end)) {
            $ret['label'] = $order->getRequest()->getPage()->translate($codes[$key][0]['label']);
            $ret['amount'] = $codes[$key][0]['rate'] * $order->getSubTotal();
        }
        return $ret;
    }
    return $ret;
}
function convertDte($dte)
{
    $d=\DateTime::createFromFormat('Y-m-d H:i:s',$dte);
    return ($d && $dte==$d->format('Y-m-d H:i:s'))? new \DateTime($dte):null;
}