$(document).ready(function () {
    $('div#flash').on('click', function () {
        $(this).hide();
    });

    $(".add_button").removeClass('addButtonForm').addClass('addButtonForm');


    $("#sidebarleft,#sidebarright").on('click', function (e) {
        e.stopPropagation();
    });


    $("div#bandeau.responsive .menu").click(function (e) {
        $(document).click(function () {
            $("div.dropdownmenu.responsive").slideUp(500);
            $(document).unbind('click');
            $('.menu').removeClass('open');
        });

        $("div.dropdownmenu.responsive").css({'width': '99.5%'});
        if ($("div.dropdownmenu.responsive").is(":visible")) {
            $("div.dropdownmenu.responsive").slideUp(500);
            $(document).unbind('click');
            $(this).removeClass('open');
        } else {
            $("div.dropdownmenu.responsive").slideDown(500);
            $(this).addClass('open');
        }
        e.stopPropagation();
    });

    $('.opencapture').bind('click', function (e) {
        e.preventDefault();
        capture($('form#capture input#email_capture').val());
    });

    $('button#btn_help').bind('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var id = $('.search-help').prop('id');
        $.fancybox({
            href: "#" + id,
            openEffect: 'fade',
            closeEffect: 'fade',
            helpers: {
                title: {
                    type: 'inside'
                },
                overlay: {
                    css: {
                        'background': 'rgba(255, 255, 255, 0.8)'
                    }
                }
            }
        });
    });

    // bouton revenir en haut
    if ($(window).width() > 960) {
        $("body").append('<div id="btn_up" title="Back to top"></div>');
        $('#btn_up').on('click', function () {
            $('html,body').animate({scrollTop: 0}, 'slow');
        });

        $(window).scroll(function () {
            if ($(window).scrollTop() < 250) {
                $('#btn_up').stop().animate({
                    opacity: 0
                });
            } else {
                $('#btn_up').stop().animate({
                    opacity: 1
                });
            }
        });
    }

    // recentre les images en responsaive
    if ($(window).width() <= 480) {
        $('img[style*=float]').css({margin: '20px 0'});
    }

    // Search thoughts
    $('.results.thoughts .result').bind('click', function () {
        if ($(this).hasClass('collapse')) {
            $('.content', $(this)).hide();
            $('.description', $(this)).show();
            $(this).removeClass('collapse');
        } else {
            $('.description', $(this)).hide();
            $('.content', $(this)).show();
            $(this).addClass('collapse');
            pvta_utils.log('view', 'thought', $(this).data('id'));
        }
    });

    // $('.thought.date').show();


    var $elt = $("input#date");
    $elt.datepicker({
        format: 'yyyy-mm-dd',
        date: datePage,
        startDate: $("input#date").data('start'),
        endDate: $("input#date").data('end'),
        language: culture.substr(0, 2)
    });

    $(".bydate").bind('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $elt.datepicker('show');
    });


    $elt.bind('pick.datepicker', function (e) {
        if (e.view == 'day') {
            var d = e.date.toLocaleDateString();
            d = d.substr(-4) + '-' + d.substr(3, 2) + '-' + d.substr(0, 2);
            window.location = folder + d;
        }
    });

    /* Aide sur la recherche */
    $('.search-help').hide();

    /* Recherche en responsive */
    $('#search-div').bind('click', function () {
        if ($('div.search.responsive').is(':visible')) {
            $("div.search.responsive").slideUp();
        } else {
            $("div.search.responsive").slideDown();
            $('html,body').animate({scrollTop: 0}, 'slow');
        }
    });

    /* slider */
    function slider() {
        var w = $(window).width();
        if (w < 800) {
            $('section#slider').hide();
            $('section#slider-responsive').show();
        } else {
            $('section#slider').show();
            $('section#slider-responsive').hide();
        }
    }

    $(window).bind('resize', slider);
    slider();

    /* Teaser pensée */
    $('div.teaser').bind('click', function () {
        $(this).hide();
        $('.thought-container').css({height: 'auto'});
    });

    $('input#cg[type=checkbox]').bind('change', function () {
        var checked = !$(this).is(':checked');
        $('input#btn-next').prop('disabled', checked);
    });

    // Décalage des thématiques toutes les semaines (milliseonds * sec * mn * h * 7 = semaine
    setTimeout(function () {
        var decalage = ((parseInt(Date.now() / (1000 * 60 * 60 * 24 * 7)) % 52) * 5) % 12;
        for (var i = 0; i < decalage; i++) {
            $('#thematics .owl-next').click()
        }
    }, 0);


    $('body').bind('basket_add', function (e, data) {
        if (data.productsCount) {
            $("#shopping").text(data.productsCount)
                .attr('title', data.title + ' - ' + data.total);
        } else {
            $("#shopping").html('&nbsp;');
        }
    });

    setTimeout(function () {
        if ($('.bx-viewport').length) {
            $('.bx-viewport').height('auto');
        }
    }, 0);

    // Gestion affichage en responsive
    responsive();
});


function responsive() {
    var screenWidth = $(window).width();
    var margin = 20;
    if ($('.article-slide').length) {
        if (screenWidth < 450) {
            $('.article-slide').css('max-width', (screenWidth - (2 * margin)) + 'px');
        }
    }

}
