<?php
// retour array('label'=>'', 'amount'=>0)
/** Order */
function discount($order)
{
    // Prome
    $subtotal=$order->getSubTotal();
    $discounts[]=_computePromo($order, $subtotal);
    $discounts[]=_computeDiscountByCountry($order, $subtotal);


    return $discounts;
}

/**
 * @param Order $order
 * @return array
 */
function _computePromo($order, &$subtotal)
{
    $ret = ['label' => '', 'amount' => 0];
    $variables = $order->getRequest()->getVariables();
    $codes = $variables->getValueByName('promo');

    $key = strtoupper($order->codepromo);
    if (is_array($codes) && array_key_exists($key, $codes)) {
        $amount=0;
        foreach($codes[$key] as $code) {
            $start = convertDte($code['start'] . ' 00:00:00');
            $end = convertDte($code['end'] . ' 23:59:59');
            $minAmount = $code['amount'];
            $now = new \DateTime();
            if ((!$start || $now >= $start) && (!$end || $now < $end) && $minAmount > $amount && $order->getSubTotal() > $minAmount) {
                $amount=$minAmount;
                $ret['label'] = $code['label'];
                $ret['amount'] = $code['rate'] * $subtotal;
                $subtotal-=$ret['amount'];
            }
        }
    }
    return $ret;
}

/**
 * @param Order $order
 * @return void
 */
function _computeDiscountByCountry($order, &$subtotal)
{
    $ret = ['label' => '', 'amount' => 0];
    $variables = $order->getRequest()->getVariables();
    $variable = $variables->getValueByName('Discount by country');
    $var=null;
    if (array_key_exists($order->country,$variable)) {
        $var=$variable[$order->country][0];
        if ($order->state!==$var['state'] && $var['state']!=='*') {
            $var=null;
        }
    } elseif (array_key_exists('*', $variable)) {
        $var=$variable['*'][0];
    }

    if ($var) {
        $ret['label']=$order->getRequest()->getPage()->translate($var['label']);
        $ret['amount']=$subtotal*$var['discount'];
        $subtotal-=$ret['amount'];
    }

    return $ret;
}

function convertDte($dte)
{
    $d=\DateTime::createFromFormat('Y-m-d H:i:s',$dte);
    return ($d && $dte==$d->format('Y-m-d H:i:s'))? new \DateTime($dte):null;
}