// JavaScript Document

/* global Cookie, trad, messages_i18n */

var pvta_utils = {};

// Default-value (class defayult-value et attribut default
pvta_utils.defaultValue = function () {
    var default_value = $(this).attr('default');
    if (this.value == '') {
        this.value = default_value;
        $(this).css({'color': '#777', 'font-style': 'italic'});
    }

    $(this).focus(function ()
    {
        if (this.value == default_value)
        {
            this.value = '';
            $(this).css({'color': '#000', 'font-style': 'normal'});
        }
    });
    $(this).blur(function ()
    {
        if (this.value == '')
        {
            this.value = default_value;
            $(this).css({'color': '#777', 'font-style': 'italic'});
        }
    });
};


// Add product into basket animation mise à jour de productsCount et tooltip de a#basketlink
pvta_utils.addButton = function (elt, event) {
    // récupère les paramètres
    var url = $(elt).attr('href');

    var product = $.QueryString('product', {href: url});
    if (product) {
        var choice = $.QueryString('choice', {href: url});
        if (choice != 1 && choice != 2)
            choice = 1;

        var qty = $.QueryString('qty', {href: url});
        if (!qty)
            qty = 1;

        var data = {action: 'add', requete: 'ajax', product: product, choice: choice, qty: qty};

        // animation
        var id = "img#" + product.toLowerCase();
        var imgUrl = $(id).attr('src')

        $("div#shoppingcontainer").css({'display': 'block'});
        $("div#shoppingcontainerempty").css({'display': 'none'});
        if ($(document).width() >= 960) {
            // sauf dans le cas de responsive
            $(id + ":first").animate_from_to("#shopping", {initial_css: {'image': imgUrl},
                pixels_per_second: 1000});
        }


        $.ajax({
            type: "GET",
            url: '',
            data: data,
            datatype: "json"})
                .done(function (xhr) {
                    var data = JSON.parse(xhr);
                    $("#shoppingcontainer #productsCount").text(data['productsCount']);
                    $("#shoppingcontainer input#productsCount").val(data['productsCount']);
                    $("#shoppingcontainer #article").text(data['article']);
                    $("#shoppingcontainer #total").text(data['total']);
                    $("#shoppingcontainer a#basketlink, #shoppingcontainer .basketlink").attr('title', data['title']);
                    $("#shoppingcontainer a#basketlink").attr('href', $("a#basketlink").attr('url'));
                });
    }

    var selection = $.QueryString('selection', {href: url});
    if (selection) {
        var choice = $.QueryString('choice', {href: url});
        if (choice != 1 && choice != 2)
            choice = 1;

        var qty = $.QueryString('qty', {href: url});
        if (!qty)
            qty = 1;

        var data = {action: 'add', requete: 'ajax', selection: selection, choice: choice, qty: qty};


        $.ajax({
            type: "GET",
            url: '',
            data: data,
            datatype: "json"})
                .done(function (xhr) {
                    var data = JSON.parse(xhr);
                    $("#shoppingcontainer #productsCount").text(data['productsCount']);
                    $("#shoppingcontainer input#productsCount").val(data['productsCount']);
                    $("#shoppingcontainer #productsCount #article").text(data['article']);
                    $("#shoppingcontainer #productsCount #total").text(data['total']);
                    $("#shoppingcontainer a#basketlink").attr('title', data['title']);
                    $("#shoppingcontainer a#basketlink").attr('href', $("a#basketlink").attr('url'));
                });
    }
    event.preventDefault();
};

pvta_utils.addButtonForm = function (elt) {
    //if ($(window).width() < 960) //{
        //return;
    //}
    // ajout un div si inexistant
    if (!($("#addProductForm").size()))
    {
        $("body").append("<div id=\"addProductForm\" style=\"display: none\"></div>");
    } else
    {
        $("#addProductForm").empty();
    }


    var url = $(elt).attr('href');
    var product = $.QueryString('product', {href: url});
    var selection = $.QueryString('selection', {href: url});
    var title = encodeURIComponent($("h1:first").text());
    url = folder + "?action=product_add" + ((product) ? '&product=' + product : '') + ((selection) ? "&selection=" + selection : '') + "&title=" + title;


    $("#addProductForm").load(url,
            function (response, status, xhr)
            {
                if (status == "error")
                {
                    var msg = "Sorry but there was an error: ";
                    $("#error").html(msg + xhr.status + " " + xhr.statusText);
                } else
                {
                    $("addProductForm").html(response);
                    setTimeout('pvta_utils.box("#addProductForm")', 500);
                }
            });





};

pvta_utils.randomString = function (size) {
    var rString = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    var result = '';
    for (var i = size; i > 0; --i)
        result += rString[Math.round(Math.random() * (rString.length - 1))];
    return result;
}

pvta_utils.share = function (elt) {
    // ajout un div si inexistant
    if (!($("#share_div").size()))
    {
        $("body").append("<div id=\"share_div\" style=\"display: none\"></div>");
    } else
    {
        $("#share_div").empty();
    }


    var link = $(elt).attr('href');
    url = link + ((link.indexOf('?') == -1) ? "?action=share" : "&action=share");
    link = encodeURIComponent(link);

    $("#share_div").load(url,
            function (response, status, xhr)
            {
                if (status == "error")
                {
                    var msg = "Sorry but there was an error: ";
                    $("#error").html(msg + xhr.status + " " + xhr.statusText);
                } else
                {
                    $("#share_div").html(response);
                    $.fancybox({
                        href: "#share_div",
                        beforeShow: function () {


                            // Add tweet button
                            this.title += '<a href="https://twitter.com/share" class="twitter-share-button" data-count="true" data-url="' + link + '">Tweet</a> ';

                            this.title += '<iframe src="//www.facebook.com/plugins/like.php?href=' + link + '&amp;layout=button_count&amp;show_faces=true&amp;width=500&amp;action=like&amp;font&amp;colorscheme=light&amp;height=23" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:110px; height:23px;" allowTransparency="true"></iframe>';
                        },
                        afterShow: function () {
                            // Render tweet button
                            twttr.widgets.load();

                        },
                        afterClose: function () {
                            $("#share_div").empty();
                        },
                        openEffect: 'elastic',
                        closeEffect: 'elastic',
                        helpers: {
                            title: {
                                type: 'inside'
                            },
                            overlay: {
                                css: {
                                    'background': 'rgba(238, 238, 238, 0.2)'
                                }
                            }
                        }
                    });
                }
            });



}

// fancyBox
pvta_utils.box = function (ref) {

    $.fancybox({
        href: ref,
        openEffect: 'elastic',
        closeEffect: 'elastic',
        helpers: {
            overlay: {
                css: {
                    'background': 'rgba(238, 238, 238, 0.2)'
                }
            }

        },
        afterClose: function () {
            $(ref).empty();
        }
    });

}
// datePicker
pvta_utils.datePicker = function (id, button) {
    if ($(id).length > 0)
    {
        if (button)
        {
            var showon = 'button';
        } else
        {
            var showon = 'focus';
        }

        // $récupère l'intervalle de date
        var url = folder + "?action=thoughtperiod";
        $.getJSON(url, function (data) {
            $(id).datepicker({
                defaultDate: "+0d",
                changeMonth: true,
                changeYear: true,
                minDate: new Date(data.min),
                maxDate: new Date(data.max),
                onSelect: function (selectedDate)
                {
                    var instance = $(this).data("datepicker");
                    var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat,
                            selectedDate, instance.settings);
                    date = $.datepicker.formatDate('yy-mm-dd', date)
                    var url = folder + date;
                    document.location = url;
                },
                showOn: showon,
                buttonImage: "/resources/images/calendar.jpg",
                buttonImageOnly: true
            });
        });

    }

};



// fonctions sendArticle
pvta_utils.sendArticleText = function (e) {
    e.preventDefault();
    pvta_utils.sendArticle('text');
};

pvta_utils.sendArticleLink = function (e) {
    e.preventDefault();
    pvta_utils.sendArticle('link');
};

pvta_utils.sendArticle = function (mailtype) {

    // vérifie existence de la div sendArticle sino n la crée
    if ($("div#sendarticle").length == 0)
    {
        $('body').append("<div id='sendarticle'>loading...</div>");
    }



    // charge le formulaire dans la div
    var data = {
        action: 'formsendarticle',
        requete: 'ajax',
        mailtype: mailtype
    };

    $("div#sendarticle").dialog({
        open: function (event)
        {
            $("div#sendarticle").load(document.location.href, data, function () {
                $("form#sendarticle button#refresh").bind('click',
                        function (event) {
                            event.stopPropagation();
                            event.preventDefault();
                            var src = $("form#sendarticle #imgcaptcha").attr("src");
                            var src2 = src.split("?")[0];
                            var d = new Date()
                            $("form#sendarticle #imgcaptcha").removeAttr("src").attr("src", src2 + "?" + d.getTime());
                        });
                        $("form#sendarticle input#code").bind("keyup", function() {
                            $(this).css({border: "inherit"});
                        });
            });

        },
        title: trad.sendArticle,
        position: 'center',
        buttons: [{text: trad.Send,
                click: function ()
                {
                    $("form#sendarticle").validate({
                        rules: {
                            fromname: {required: true, minlength: 2},
                            from: {required: true, email: true},
                            to: {required: true, email: true}
                        },
                        messages: messages_i18n
                    });
                   
//                    $("form#sendarticle").submit();
                    
                    var formdata = $("form#sendarticle").serializeArray();
                    var data={};
                    $.each(formdata, function(k,v) {
                        data[v.name]=v.value;
                    });
                    var url = document.location.href;
                    $.ajax({
                        url: url,
                        type: 'POST',
                        data: data,
                        datatype: 'json',
                        success: function (result) {
                            var data=JSON.parse(result);
                            if (data.message === 'NOK') {
                                $("form#sendarticle input#code").val("").css({border: "2px solid red"});
                            } else {
                                $("div#sendarticle").dialog('close').empty();
                            }
                            return;
                        }
                    });
                }
            },
            {text: trad.Cancel,
                click: function () {
                    $("div#sendarticle").dialog('close');
                }
            }],
        rezisable: false,
        autoopen: true,
        width: 700,
        close: function() {
             $("div#sendarticle").empty();
        }
    });
};

// Cookie
pvta_utils.cookie = function () {
    if ($("#cookie #text").text()) {
        if (!Cookies.get('validcookie')) {
            $('#cookie').show();
            $("#cookie #close").click(function () {
                $('#cookie').hide(500);
            });
        }
        Cookies.set('validcookie', true);
    }
};

// Google analytics
pvta_utils.trackEvent = function () {
    var e = $(this).attr('ga_event');
    e = e.split(";", 4);
    var category = e[0].toString();
    var action = e[1].toString();
    var opt_lib = (e[2]) ? e[2].toString() : "";
    var opt_val = (parseInt(e[3])) ? parseInt(e[3]) : 1;

    // choix du paiement
    if (category == 'Order' && action == 'choosePaiement') {
        opt_lib = $("input[name='mode']:checked").val();
    }

    if (category && action && opt_lib) {
        _gaq.push(['_trackEvent', category, action, opt_lib, opt_val]);
    } else {
        if (category && action) {
            _gaq.push(['_trackEvent', category, action]);
        }
    }

}

// changement de langue du widget
pvta_utils.widgetlanguagethought = function () {
    var code = $("#widgetthought").data('code');
    var lg = $("#widgetlanguagethought").val();

    code = code.replace('[language]', lg);

    $("#widgetthought").html(code);
}

// test du widget
pvta_utils.widgetthoughttest = function () {
    var win = window.open('', 'test', 'width=640, height=480');
    var code = $("#widgetthought").html();
    var decoded = $('<div/>').html(code).text();
    win.document.write('<html><head><title>Preview</title></head><body>' + decoded + '</body></html>');//decoded;
    win.focus();
}
// initialisation
pvta_utils.initialize = function () {
    // valeur par defaut
    $('.default-value').each(pvta_utils.defaultValue);

    // cache les classe js-hide
    $(".js-hide").css({'display': 'none'});

    // si DatePicker
    pvta_utils.datePicker('#datePicker', false);

    // si DatePickerBtn
    pvta_utils.datePicker('#datePickerBtn', true);


    // liaison à sendArticle
    $(".sendarticle").bind('click', pvta_utils.sendArticleLink);
    $(".sendarticletext").bind('click', pvta_utils.sendArticleText);

    // Print
    $(".printarticle").bind('click', function (event) {
        if (typeof (window.print) != 'undefined') {
            window.print();
        }
    });

    // share
    $(".share").bind('click', function (event) {
        pvta_utils.share(this);
        event.preventDefault();
    });
    // add_button
    $('.add_button').bind('click', function (event) {
        pvta_utils.addButton(this, event);
    });

    $('.addButtonForm').bind('click', function (event) {
        pvta_utils.addButtonForm(this);
        event.preventDefault();
    });

    // validation de la select product lang
    $("select#productlanguage").bind("change", function (event)
    {
        $("form#selectcataloglang").submit();
    });

    // tri des résultats
    $('select#sort').bind("change", function (event) {
        $("form#sort").submit();
    });

    // Not in catalog
    $('div#dialog').dialog({
        autoOpen: false,
        width: 500,
        buttons: {"Ok": function () {
                $("div#dialog").dialog("close");
            }},
        rezisable: false
    });
    $('div#dialog').dialog("option", "position", "center");
    $("a#notincatalog").click(function (event) {
        if ($("dialog").dialog("isOpen"))
            $("#dialog").dialog("open");
        event.preventDefault();
    });

    // image zoomable
    $("img.zoomable").each(function () {
        var href = $(this).attr("src");
        if (href) {
            href = href.replace("-small.", ".");
            var title = $(this).attr('alt');
            if (!title)
                title = '';
            $(this).wrap("<a href=\"" + href + "\" class=\"fancybox\" title=\"" + title + "\" ></a>");
        }
    });

    $(".fancybox-iframe").fancybox({
        'type': 'iframe',
        openEffect: 'elastic',
        closeEffect: 'elastic',
        showCloseButton: true,
        helpers: {
            overlay: {
                css: {
                    'background': 'rgba(238, 238, 238, 0.2)'
                }
            }
        }
    });

    $(".fancybox-media").fancybox({
        helpers: {
            media: {},
            overlay: {
                css: {
                    'background': 'rgba(238, 238, 238, 0.2)'
                }
            }
        }
    });

    $(".fancybox").fancybox({
        helpers: {
            overlay: {
                css: {
                    'background': 'rgba(238, 238, 238, 0.2)'
                }

            }


        }

    });

    $(".ga_trackevent").click(pvta_utils.trackEvent);

};

pvta_utils.log = function (verb, object, object_id, note) {
    function addLog(url) {
        $.ajax({
            url: url,
            method: 'GET',
            datatype: 'JSON',
            complete: function (jqXHR, textStatus) {
                jqXHR;
            }
        });
    }

    if (verb == undefined) {
        var log = null;
        $('[data-log]').each(function () {
            log = $(this).data('log');
            log = log.split(':');
            if (log.length >= 3) {
                var url = folder + '?action=log&verb=' + log[0] + '&o=' + log[1] + '&oid=' + log[2];
                if (log.length == 4) {
                    url += '&v=' + log[3];
                }
                addLog(url);
            }
        });
    } else {
        var url = folder + '?action=log&verb=' + verb + '&o=' + object + '&oid=' + object_id;
        if (note != undefined) {
            url += '&v=' + note;
        }
        addLog(url);
    }
};

$(document).ready(function () {


    pvta_utils.initialize();
    pvta_utils.cookie();
	pvta_utils.log();

});