<?php

class BeforeCompute {

    private $order;
    private $params;
    private $goodParams;
    private $CRParams;

    public function __construct($order) {
        $this->order = $order;
        $this->goodParams = $this->getParams();
        $this->CRParams = $this->getCRParams();
    }

    public function compute() {
        $cart = $this->order->getCart();
        // calcul remise
        $cart = $this->computeDiscount($cart);

        $cart = $this->computeContraSsegno($cart);

        return $cart;
    }

    private function computeContraSsegno($cart) {
        $contrassegno = ($this->order->orderPaymentMode === 'Invoice');

        if ($this->order->step >= 4 && $contrassegno) {
            $ok = false;
            foreach ($cart as $idx => $row) {
                if ($ok = $this->isContrassegnoLine($row)) {
                    break;
                }
            }
            if (!$ok) {
                // add contrassegno
                $cart[] = ['amount' => $this->CRParams->price,
                    'price' => $this->CRParams->price,
                    'standardPrice' => $this->CRParams->price,
                    'quantity' => 1,
                    'reference' => $this->CRParams->code,
                    'title' => $this->CRParams->text];
            }
        } else {
            $ret = [];
            foreach ($cart as $idx => $row) {
                if (!$this->isContrassegnoLine($row)) {
                    $ret[] = $row;
                }
            }
            $cart = $ret;
        }
        return $cart;
    }

    public function isContrassegnoLine($row) {
        return ($row['reference'] == $this->CRParams->code);
    }

    private function computeDiscount($cart) {
        if ($this->goodParams) {
            $total = 0;
            // calcul du total sans les remises
            foreach ($cart as $row) {
                $total += $row['quantity'] * $row['standardPrice'];
            }

            foreach ($cart as $idx => $row) {
                if (in_array($row['reference'], $this->params->products)) {
                   if ($total >= $this->params->minimum) {
                        $cart[$idx]['price'] = (1 - $this->params->discount) * $row['standardPrice'];
                   } else {
                       $cart[$idx]['price'] = Product::getFinalPrice($row['reference'], $this->order->getRequest()->getSite()->distributor_id);
                   }
                    $cart[$idx]['amount'] = $row['quantity'] * $cart[$idx]['price'];
                }
            }
        }
        return $cart;
    }

    private function getParams() {
        $this->params = $this->order->getRequest()
                ->getVariables()
                ->getValueByName('discount');
        return (is_object($this->params) && isset($this->params->minimum) && isset($this->params->discount) && isset($this->params->products) && is_array($this->params->products));
    }

    private function getCRParams() {
        $CR = $this->order->getRequest()
                ->getVariables()
                ->getValueByName('contrassegno');

        if (!is_object($CR)) {
            $CR = new \stdClass();
        }
        return $CR;
    }

}
