<?php

function taxes(Order $order) {
    $taxes = [];

    // Taxe pour CANADA
    if ($order->fct_country == 'CA') {
        $variables = $order->getRequest()->getVariables();

        $v = $variables->getValueByName('statesTVH');
        $statesTVH = ($v && is_object($v) && isset($v->provinces)) ? $v->provinces : [];

        $v = $variables->getValueByName('ExceptionsMedias');
        $exceptionsMedias = ($v && is_object($v) && isset($v->references)) ? $v->references : [];

        $isStateTVH = in_array($order->fct_state, $statesTVH);
        $isQuebec = ($order->fct_state == 'QC');

        $ret['T.P.S.'] = 0;
        $ret['T.V.Q.'] = 0;
        $ret['T.V.H.'] = 0;

        foreach ($order->getCart() as $row) {
            $reference = $row['reference'];
            $isMedia = ((Product::getProductType($reference) == 'media' || Product::getProductType($reference) == 'miscellaneous' ) && !in_array($row['reference'], $exceptionsMedias));

            // TPS
            if (!$isMedia || !$isStateTVH) {
                $tps = $variables->getValueByName('TPS');
                $ret['T.P.S.']+=$row['amount'] * $tps;
            }

            // TVQ
            if ($isMedia && $isQuebec) {
                $tvq = $variables->getValueByName('TVQ');
                $ret['T.V.Q.']+=$row['amount'] * $tvq;
            }

            // TVH
            if ($isMedia && $isStateTVH) {
                $tvh = $variables->getValueByName('TVH');
                $ret['T.V.H.']+=$row['amount'] * $tvh;
            }
        }
    }

    foreach ($ret as $key => $value) {
        if ($value) {
            $taxes[$key] = round($value, 2);
        }
    }

    return $taxes;
}