<?php

function taxes(Order $order) {
    $taxes = [];
    $ret = [];
    // Taxe pour CANADA : TPS
    if ($order->fct_country == 'CA') {
        $variables = $order->getRequest()->getVariables();

        $v = $variables->getValueByName('TVH');
        $tvh = ($v && is_object($v) && isset($v->tvh)) ? $v->tvh : [];

        $v = $variables->getValueByName('ExceptionsMedias');
        $exceptionsMedias = ($v && is_object($v) && isset($v->references)) ? $v->references : [];

        $isStateTVH = array_key_exists($order->fct_state, $tvh);
        $isQuebec = ($order->fct_state == 'QC');

        $ret['T.P.S.'] = 0;
        $ret['T.V.Q.'] = 0;
        $ret['T.V.H.'] = 0;

        foreach ($order->getCart() as $row) {
            $reference = $row['reference'];
            $isMedia = ((Product::getProductType($reference) == 'media' || Product::getProductType($reference) == 'miscellaneous' ) && !in_array($row['reference'], $exceptionsMedias));

            // TPS
            if (!$isMedia || !$isStateTVH) {
                $tps = $variables->getValueByName('TPS');
                $ret['T.P.S.']+=$row['amount'] * $tps;
            }

            // TVQ
            if ($isMedia && $isQuebec) {
                $tvq = $variables->getValueByName('TVQ');
                $ret['T.V.Q.']+=$row['amount'] * $tvq;
            }

            // TVH
            if ($isMedia && $isStateTVH) {
                $tauxTvh = $tvh->{$order->fct_state};
                $ret['T.V.H.']+=$row['amount'] * $tauxTvh;
            }
        }
    }

    foreach ($ret as $key => $value) {
        if ($value) {
            $taxes[$key] = round($value, 2);
        }
    }

    return $taxes;
}